<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<#comment>通用配置文件</#comment>
<#assign nacosUrl = "172.16.102.211:8848" >
<#assign redisHost = "172.16.100.243" >
<#assign redisPort = "6379" >
<#assign redisDataBase = "0" >
<#assign dbUserName="root">
<#assign dbPassWord="123456">
<#assign dbUrl="jdbc:mysql://127.0.0.1:3306/"+sys.name+"?autoReconnect=true&useUnicode=true&characterEncoding=UTF-8&useOldAliasMetadataBehavior=true">
<#assign dbDriver="com.mysql.jdbc.Driver">
<#comment>前端应用微服务平台配置</#comment>
<#if sys.getAllPSDevSlnMSDepApps()??>
  <#list sys.getAllPSDevSlnMSDepApps() as depApp>
      <#if depApp.getPSDCMSPlatform()??>
        <#assign appPlatform=depApp.getPSDCMSPlatform()>
        <#if appPlatform.getUserParam("nacos","172.16.102.211:8848")??>
          <#assign nacosUrl = appPlatform.getUserParam("nacos","172.16.102.211:8848")>
        </#if>
        <#if appPlatform.getUserParam("spring.redis.host","172.16.100.243")??>
          <#assign redisHost = appPlatform.getUserParam("spring.redis.host","172.16.100.243")>
        </#if>
        <#if appPlatform.getUserParam("spring.redis.port","6379")??>
          <#assign redisPort = appPlatform.getUserParam("spring.redis.port","6379")>
        </#if>
        <#if appPlatform.getUserParam("spring.redis.database","0")??>
          <#assign redisDataBase = appPlatform.getUserParam("spring.redis.database","0")>
        </#if>
        <#break>
    </#if>
  </#list>
</#if>
<#comment>服务接口微服务平台配置</#comment>
<#if sys.getAllPSDevSlnMSDepAPIs()??>
  <#list sys.getAllPSDevSlnMSDepAPIs() as depSysApi>
    <#if depSysApi.getPSDCMSPlatform()?? >
      <#assign sysApiPlatform=depSysApi.getPSDCMSPlatform()>
      <#if sysApiPlatform.getUserParam("nacos","172.16.102.211:8848")??>
        <#assign nacosUrl = sysApiPlatform.getUserParam("nacos","172.16.102.211:8848")>
      </#if>
      <#if sysApiPlatform.getUserParam("spring.redis.host","172.16.100.243")??>
        <#assign redisHost = sysApiPlatform.getUserParam("spring.redis.host","172.16.100.243")>
      </#if>
      <#if sysApiPlatform.getUserParam("spring.redis.port","6379")??>
        <#assign redisPort = sysApiPlatform.getUserParam("spring.redis.port","6379")>
      </#if>
      <#if sysApiPlatform.getUserParam("spring.redis.database","0")??>
        <#assign redisDataBase = sysApiPlatform.getUserParam("spring.redis.database","0")>
      </#if>
      <#break>
    </#if>
  </#list>
</#if>
<#comment>一键发布数据库配置</#comment>
<#if sysrun.getPSDBDevInst()??>
    <#assign sysRunDBInst = sysrun.getPSDBDevInst()>
    <#assign dbUserName=sysRunDBInst.getUserName()>
    <#assign dbPassWord=sysRunDBInst.getPassword()>
    <#assign dbUrl=sysRunDBInst.getConnUrl()>
    <#if (sysRunDBInst.getDBType()=='MYSQL5')>
        <#assign dbDriver="com.mysql.jdbc.Driver">
    <#elseif (sysRunDBInst.getDBType()=='DB2')>
        <#assign dbDriver="com.ibm.db2.jcc.DB2Driver">
    <#elseif (sysRunDBInst.getDBType()=='ORACLE')>
        <#assign dbDriver="oracle.jdbc.driver.OracleDriver">
    <#elseif (sysRunDBInst.getDBType()=='SQLSERVER')>
        <#assign dbDriver="com.microsoft.sqlserver.jdbc.SQLServerDriver">
    <#elseif (sysRunDBInst.getDBType()=='POSTGRESQL')>
        <#assign dbDriver="org.postgresql.Driver">
    <#elseif (sysRunDBInst.getDBType()=='PPAS')>
        <#assign dbDriver="com.edb.Driver">
    </#if>
</#if>
<#comment>部署-前端应用数据库配置</#comment>
<#if sys.getAllPSDevSlnMSDepApps()??>
  <#list sys.getAllPSDevSlnMSDepApps() as depApp>
    <#if depApp.getPSDBDevInst()??>
      <#assign appDBInst=depApp.getPSDBDevInst()>
      <#assign dbUserName=appDBInst.getUserName()>
      <#assign dbPassWord=appDBInst.getPassword()>
      <#assign dbUrl=appDBInst.getConnUrl()>
      <#if (appDBInst.getDBType()=='MYSQL5')>
        <#assign dbDriver="com.mysql.jdbc.Driver">
      <#elseif (appDBInst.getDBType()=='DB2')>
        <#assign dbDriver="com.ibm.db2.jcc.DB2Driver">
      <#elseif (appDBInst.getDBType()=='ORACLE')>
        <#assign dbDriver="oracle.jdbc.driver.OracleDriver">
      <#elseif (appDBInst.getDBType()=='SQLSERVER')>
        <#assign dbDriver="com.microsoft.sqlserver.jdbc.SQLServerDriver">
      <#elseif (appDBInst.getDBType()=='POSTGRESQL')>
        <#assign dbDriver="org.postgresql.Driver">
      <#elseif (appDBInst.getDBType()=='PPAS')>
        <#assign dbDriver="com.edb.Driver">
      </#if>
      <#break>
    </#if>
  </#list>
</#if>
<#comment>部署-服务接口数据库配置</#comment>
<#if sys.getAllPSDevSlnMSDepAPIs()??>
  <#list sys.getAllPSDevSlnMSDepAPIs() as depSysApi>
    <#if depSysApi.getPSDBDevInst()??>
      <#assign sysApiDBInst=depSysApi.getPSDBDevInst()>
      <#assign dbUserName=sysApiDBInst.getUserName()>
      <#assign dbPassWord=sysApiDBInst.getPassword()>
      <#assign dbUrl=sysApiDBInst.getConnUrl()>
      <#if (sysApiDBInst.getDBType()=='MYSQL5')>
        <#assign dbDriver="com.mysql.jdbc.Driver">
      <#elseif (sysApiDBInst.getDBType()=='DB2')>
        <#assign dbDriver="com.ibm.db2.jcc.DB2Driver">
      <#elseif (sysApiDBInst.getDBType()=='ORACLE')>
        <#assign dbDriver="oracle.jdbc.driver.OracleDriver">
      <#elseif (sysApiDBInst.getDBType()=='SQLSERVER')>
        <#assign dbDriver="com.microsoft.sqlserver.jdbc.SQLServerDriver">
      <#elseif (sysApiDBInst.getDBType()=='POSTGRESQL')>
        <#assign dbDriver="org.postgresql.Driver">
      <#elseif (sysApiDBInst.getDBType()=='PPAS')>
        <#assign dbDriver="com.edb.Driver">
      </#if>
      <#break>
    </#if>
  </#list>
</#if>
#nacos配置中心、数据源
spring:
  cloud:
    nacos:
      discovery:
        server-addr: ${nacosUrl}
  cache:
    redis:
      time-to-live: 3600
    caffeine:
      spec: initialCapacity=5,maximumSize=500,expireAfterWrite=3600s
  redis:
    host: ${redisHost}
    port: ${redisPort}
    password:
    database: ${redisDataBase}
    lettuce:
      pool:
        max-active: 32
        max-wait: 300ms
        max-idle: 16
        min-idle: 8
  datasource:
    username: ${dbUserName}
    password: '${dbPassWord}'
    url: ${dbUrl}
    driver-class-name: ${dbDriver}
    filters: stat,wall,log4j2
    #配置初始化大小/最小/最大
    initial-size: 1
    min-idle: 1
    max-active: 20
    #获取连接等待超时时间
    max-wait: 60000
    #间隔多久进行一次检测，检测需要关闭的空闲连接
    time-between-eviction-runs-millis: 60000
    #一个连接在池中最小生存的时间
    min-evictable-idle-time-millis: 300000
    validation-query: SELECT 1 FROM DUAL
    test-while-idle: true
    test-on-borrow: false
    test-on-return: false
    #打开PSCache，并指定每个连接上PSCache的大小。oracle设为true，mysql设为false。分库分表较多推荐设置为false
    pool-prepared-statements: false
    max-pool-prepared-statement-per-connection-size: 20
    isSyncDBSchema: false
    defaultSchema: ${dbUserName}
    conf: classpath:liquibase/master.xml

#Mybatis-plus配置
mybatis-plus:
  global-config:
    refresh-mapper: true
    db-config:
      # 全局逻辑已删除默认值
      logic-delete-value: 0
      # 全局逻辑未删除默认值
      logic-not-delete-value: 1
  mapper-locations: classpath*:/mapper/*/*/*.xml
  configuration:
    jdbc-type-for-null: 'null'
    map-underscore-to-camel-case: false

#阿里sentinel熔断器
feign:
  httpclient:
    enabled: true
  sentinel:
    enabled: true

#Log配置
logging:
  level:
    ${pub.getPKGCodeName()}: debug
    org.springframework.boot.autoconfigure: ERROR

#zuul网关超时设置
ribbon:
  ReadTimeout: 60000
  ConnectTimeout: 60000

<#assign enableDataAcc="false">
#系统是否开启权限验证、是否开启缓存
#缓存级别：无缓存(无配置项)、一级缓存(L1)、二级缓存(L2)
ibiz:
  <#if sys.getPSSystemSetting()?? && sys.getPSSystemSetting().getDataAccCtrlArch()?? && sys.getPSSystemSetting().getDataAccCtrlArch()==1>
    <#assign enableDataAcc="true">
  </#if>
  enablePermissionValid: ${enableDataAcc}
  cacheLevel: L1 #(L1)一级本地caffeine缓存;(L2)caffeine缓存+Redis缓存

